﻿// FORMAT:  1  (format 2 decompressed)


// get tileSize
formats[1].get.tileSize = function(){
	return 16;
}
// get map's width
formats[1].get.width = function(){
	return current.data.width;
}
// get map's height
formats[1].get.height = function(){
	return current.data.height;
}
// get tile's chipset index
formats[1].get.tileChipIndex = function( location ){
	return 0;
}
// get quantity of chipsets
formats[1].get.chipsetQuantity = function(){
	return 1;
}
// get maximum allowed quantity of chipsets
formats[1].get.maxChipsetQuantity = function(){
	return 1;
}
// get maximum supported chipset size, in tiles		(max quantity of tiles horz & vert)
formats[1].get.maxChipsetSize = function(){
	return {
		width: 30,
		height: 16		// rm2k max = 16,  theoretical max = 43.2
	}// {}
}
// get quantity of layers
formats[1].get.layerQuantity = function(){
	return current.data.layers.length;
}
// get chipset's file
formats[1].get.chipsetFile = function( chipsetIndex ){
	return (chipsetIndex==0) ? current.data.chipset : undefined;
}
// get copy of all chipset data for selection data
formats[1].get.allChipsets = function(){
	return [current.data.chipset];
}
// get tile data  (returns a copy)
formats[1].get.tile = function( location ){
	var chipsetWidth = 30;
	var tileValue = current.data.layers[location.layer][location.x][location.y];
	//var tileValue = (tileData.y * chipsetWidth) + tileData.x;
	return {
		chipset: 0,
		x: tileValue % chipsetWidth,
		y: Math.floor( tileValue / chipsetWidth )
	}
}
// get all map data
formats[1].get.data = function(){
	return current.data;
}
// get collision value of a tile
formats[1].get.collisionTile = function( loc ){
	return current.data.collision[loc.x][loc.y];
}





// set tileSize
formats[1].set.tileSize = function( newTileSize ){
	// do nothing.  Map2 always uses 16x16 tiles
}


// set map's width
formats[1].set.width = function( newWidth ){
	if(newWidth == current.data.width )		return;		// same width = do nothing
	var xDiff = Math.abs(current.data.width - newWidth);
	
	// tiles
	for(var l=0; l<current.data.layers.length; l++){
		var thisGrid = current.data.layers[l];
		if(newWidth > current.data.width )
		{// if:  wider
			// // create new columns
			var newColumns = [];
			for(var xx=0; xx<xDiff; xx++){
				newColumns[xx] = [];
				for(var yy=0; yy<current.data.height; yy++){
					newColumns[xx][yy] = data.create.blankTile();
				}// for:  map's height
			}// for:  added width
			// // add new columns to the right
			thisGrid.splice.apply( thisGrid, [thisGrid.length, 0].concat(newColumns) );
		}// if:  wider
		if(newWidth < current.data.width )
		{// if:  narrower
			// // remove columns from the right
			thisGrid.splice( -xDiff, xDiff );
		}// if:  narrower
	}// for:  each layer
	
	
	// collision
	var thisGrid = current.data.collision;
	if(newWidth > current.data.width)
	{// if:  wider
		// // create new columns
		var newColumns = [];
		for(var xx=0; xx<xDiff; xx++){
			newColumns[xx] = [];
			for(var yy=0; yy<current.data.height; yy++){
				newColumns[xx][yy] = data.create.blankCollisionValue();
			}// for:  map's height
		}// for:  added width
		// // add new columns to the right
		thisGrid.splice.apply( thisGrid, [thisGrid.length, 0].concat(newColumns) );
	}// if:  wider
	if(newWidth < current.data.width )
	{// if:  narrower
		// // remove columns from the right
		thisGrid.splice( -xDiff, xDiff );
	}// if:  narrower
	
	current.data.width = newWidth;
}// set width()



// set map's height
formats[1].set.height = function( newHeight ){
	if(newHeight == current.data.height)		return;		// same height = do nothing
	var yDiff = Math.abs(current.data.height - newHeight);
	
	// tiles
	for(var l=0; l<current.data.layers.length; l++){
		var thisGrid = current.data.layers[l];
		for(var xx=0; xx<current.data.width; xx++){
			var thisColumn = thisGrid[xx];
			
			if(newHeight > current.data.height)
			{// if:  taller
				// // create new tiles
				var newTiles = [];
				for(var yy=0; yy<yDiff; yy++){
					newTiles[yy] = data.create.blankTile();
				}// for:  added height
				// // add new columns to the bottom
				thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat( newTiles) );
			}// if:  taller
			
			if(newHeight < current.data.height)
			{// if:  shorter
				// // remove columns from the bottom
				thisColumn.splice( -yDiff, yDiff );
			}// if:  shorter
		}// for:  map's width
	}// for:  each layer
	
	
	// collision
	var thisGrid = current.data.collision;
	for(var xx=0; xx<current.data.width; xx++){
		var thisColumn = thisGrid[xx];
		
		if(newHeight > current.data.height)
		{// if:  taller
			// // create new tiles
			var newTiles = [];
			for(var yy=0; yy<yDiff; yy++){
				newTiles[yy] = data.create.blankCollisionValue();
			}// for:  added height
			// // add new columns to the bottom
			thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat( newTiles) );
		}// if:  taller
		
		if(newHeight < current.data.height)
		{// if:  shorter
			// // remove columns from the bottom
			thisColumn.splice( -yDiff, yDiff );
		}// if:  shorter
	}// for:  map's width
	
	current.data.height = newHeight;
}// set height()


// set chipset's file
formats[1].set.chipsetFile = function( chipsetIndex, filePath ){
	current.data.chipset = filePath;
}
// set tile data
formats[1].set.tile = function( location, tileData ){
	if(tileData.y < 16){
		var chipsetWidth = 30;
		var tileValue = (tileData.y * chipsetWidth) + tileData.x;
		current.data.layers[location.layer][location.x][location.y] = tileValue;
	}// if:  tile isn't out of range
}
// set tile's chipset index
formats[1].set.tileChipIndex = function( location, newChipIndex ){
	// do nothing.  All Map2 tiles only use one chipset.
}
// set all chipset files
formats[1].set.allChipsets = function( chipFile_ary ){
	current.data.chipset = chipFile_ary[0];
}
// replace internal data
formats[1].set.data = function( newData ){
	// if:  very old map file
	if( newData.format == undefined ){
		newData.format = 1;		// very old maps were never compressed
	}// if:  very old map file
	
	// if:  data is old map format  &  compressed
	if( newData.format == 2 ){
		newData = formats[1].create.uncompressedMap( newData );
	}// if:  data is old map format  &  compressed
	
	if(newData.format === current.data.format){
		current.data = newData;
	}else{
		changeFormat( newData.format );
		// prevent the new interface's set.data() from reacting to this particular format change
		current.data = {};		// current data might not exist yet
		current.data.format = newData.format;
		// call the new interface's set.data() command
		data.set.data( newData );
	}
}
// set collision value of a tile
formats[1].set.collisionTile = function( loc, newValue ){
	current.data.collision[loc.x][loc.y] = newValue;
}


// add chipset at
formats[1].add.chipset = function( chipIndex, chipFile ){
	if(chipIndex == 0){
		current.data.chipset = chipFile;
	}
}
// add layer at
formats[1].add.layer = function( layerIndex, tileData ){
	var newTile = tileData || data.create.blankTile();
	var chipsetWidth = 30;
	var tileValue = (newTile.y * chipsetWidth) + newTile.x;
	var newLayer = [];
	var column = [];
	for(var yy=0; yy<data.get.height(); yy++){
		column[yy] = tileValue;
	}// for:  height
	for(var xx=0; xx<data.get.width(); xx++){
		newLayer[xx] = column.slice();		// clone this column of tiles
	}// for:  width
	current.data.layers.splice( layerIndex, 0, newLayer );
}


// remove chipset at
formats[1].remove.chipset = function( chipIndex ){
	// do nothing.  Map2 data always has exactly 1 chipset.
}
// remove layer at
formats[1].remove.layer = function( layerIndex ){
	current.data.layers.splice( layerIndex, 1 );
}


// create tile data  (blank)
formats[1].create.blankTile = function(){
	return {
		chipset: 0,
		x: 0,
		y: 0
	}
}

// create tile from chipset
formats[1].create.tileFromChipset = function( xChip, yChip, chipIndex ){
	return {
		chipset: 0,		// Map2 only has 1 chipset
		x: xChip,
		y: yChip
	}
}

// create new map data
formats[1].create.map = function( width, height, tileSize, format ){
	var output = {};
	
	var width = width || 20;
	var height = height || 15;
	var format = format || 1;
	
	if(format !== 1){
		// call the create.map() function for that format
		return formats[format].create.map.apply( this, arguments );
	}// if:  different format
	
	// default values
	var newTileValue = 0;
	var newChipFile = "chipset\\basis.png";
	
	// containers
	output.collision = [];
	output.layers = [];
	
	// root variables
	output.format = 1;		// 1 = un-compressed,  2 = compressed
	output.width = width;
	output.height = height;
	// chipset file
	output.chipset = newChipFile;
	
	// construct un-compressed collision data
	var collisionColumn = [];
	for(var yy=0; yy<output.height; yy++){
		collisionColumn[yy] = data.create.blankCollisionValue();
	}// for:  height
	for(var xx=0; xx<output.width; xx++){
		output.collision[xx] = collisionColumn.slice();		// clone this column of collision data
	}// for:  width
	
	// construct un-compressed tile data
	output.layers[0] = [];		// create layer Zero
	var tileColumn = [];
	for(var yy=0; yy<output.height; yy++){
		tileColumn[yy] = newTileValue;
	}// for:  height
	for(var xx=0; xx<output.width; xx++){
		output.layers[0][xx] = tileColumn.slice();
	}// for:  width
	
	return output;
}// create map()



// create un-compressed collision data
formats[1].create.compressedCollision = function( uncompressedCollision, width, height ){
	var colWidth = width || uncompressedCollision.length;
	var colHeight = height || uncompressedCollision[0].length;
	// collision
	var collisionString = "";
	//var collisionString = "_";		// prevents XML reader from seeing this as a HUGE number
	for(var xx=0; xx<colWidth; xx++)
	{
		for(var yy=0; yy<colHeight; yy++)
		{
			var thisData = uncompressedCollision[xx][yy];
			var thisString = thisData.toString( 36 );
			collisionString += thisString;		// append the data
		}// for:  height
	}// for:  width
	return collisionString;
}// create compressed collision()



// create compressed collision data
formats[1].create.uncompressedCollision = function( compressedCollision, width, height ){
	var colWidth = width;
	var colHeight = height;
	var readIndex = 0;
	if(compressedCollision.charAt(0) == "_"){
		readIndex++;		// skip the _ character
	}
	var newCollision = [];
	for(var xx=0; xx<colWidth; xx++)
	{
		newCollision[xx] = [];
		for(var yy=0; yy<colHeight; yy++)
		{
			// get data & convert it from:  base-36 string array -> 2D-array of Numbers
			var thisString = compressedCollision.charAt( readIndex );
			if(thisString == "0x"){		// 0x is misread as HEX, so handle it manually
				var thisValue = 33;
			}else{
				var thisValue = parseInt( thisString, 36 );
			}
			readIndex++;
			// write data
			newCollision[xx][yy] = thisValue;
		}// for y
	}// for x
	
	return newCollision;
}// create un-compressed collision()


// create un-compressed map data, from compressed map data
formats[1].create.uncompressedMap = function( compact_obj ){
	// very old maps are actually format 1,  but omit the "format" variable.
	if( compact_obj.format == undefined )		compact_obj.format = 1;
	// if:   already un-compressed,  then return the same data
	if( compact_obj.format === 1 )		return compact_obj;
	
	var format = compact_obj.format;
	if(format !== 2){
		// call the create.map() function for that format
		return formats[format].create.uncompressedMap.apply( this, arguments );
	}// if:  different format
	
	var expanded_obj = {};
	expanded_obj.format = 1;		// format 2 = un-compressed
	expanded_obj.width = compact_obj.width;
	expanded_obj.height = compact_obj.height;
	expanded_obj.chipset = compact_obj.chipset;
	
	// tiles
	expanded_obj.layers = [];
	for (lay=0; lay<compact_obj.layers.length; lay++)
	{
		expanded_obj.layers[lay] = [];
		var readIndex = 0;
		if(compact_obj.layers[lay].charAt(0) == "_"){
			readIndex++;		// skip the _ character
		}
		for (var xx=0; xx<compact_obj.width; xx++)
		{
			expanded_obj.layers[lay][xx] = [];
			for (var yy=0; yy<compact_obj.height; yy++)
			{
				// get data & convert it from:  base-36 string array -> 2D-array of Numbers
				var thisString = compact_obj.layers[lay].substr( readIndex, 2 );
				if(thisString == "0x"){		// 0x is misread as HEX, so handle it manually
					var thisValue = 33;
				}else{
					var thisValue = parseInt( thisString, 36 );
				}
				readIndex += 2;
				expanded_obj.layers[lay][xx][yy] = thisValue;
			}// for:  width
		}// for:  height
	}// for:  layers
	
	
	// collision
	expanded_obj.collision = formats[1].create.uncompressedCollision( compact_obj.collision, compact_obj.width, compact_obj.height );
	/*
	var readIndex = 0;
	if(compact_obj.collision.charAt(0) == "_"){
		readIndex++;		// skip the _ character
	}
	expanded_obj.collision = [];
	for(var xx=0; xx<compact_obj.width; xx++)
	{
		expanded_obj.collision[xx] = [];
		for(var yy=0; yy<compact_obj.height; yy++)
		{
			// get data & convert it from:  base-36 string array -> 2D-array of Numbers
			var thisString = compact_obj.collision.charAt( readIndex );
			if(thisString == "0x"){		// 0x is misread as HEX, so handle it manually
				var thisValue = 33;
			}else{
				var thisValue = parseInt( thisString, 36 );
			}
			readIndex++;
			// write data
			expanded_obj.collision[xx][yy] = thisValue;
		}// for y
	}// for x
	*/
	// output the result
	return expanded_obj;
}// create uncompressedMap()


// create compressed map data, from un-compressed map data
formats[1].create.compressedMap = function( expanded_obj ){
	
	// very old maps are actually format 1,  but omit the "format" variable.
	if( expanded_obj.format == undefined )		expanded_obj.format = 1;
	// if:   already compressed,  then return the same data
	if( expanded_obj.format == 2 )		return expanded_obj;
	
	var format = expanded_obj.format;
	if(format !== 1){
		// call the create.map() function for that format
		return formats[format].create.compressedMap.apply( this, arguments );
	}// if:  different format
	
	var compact_obj = {};
	compact_obj.format = 2;		// format 2 = compressed
	compact_obj.width = expanded_obj.width;
	compact_obj.height = expanded_obj.height;
	compact_obj.chipset = expanded_obj.chipset;
	
	// layers
	compact_obj.layers = [];
	for(var lay=0; lay<expanded_obj.layers.length; lay++)
	{
		var layerString = "_";		// prevents XML reader from seeing this as a HUGE number
		for(var xx=0; xx<expanded_obj.width; xx++)
		{
			for(var yy=0; yy<expanded_obj.height; yy++)
			{
				var thisData = expanded_obj.layers[lay][xx][yy];
				var thisString = thisData.toString( 36 );
				// add padding if neccessary
				if(thisString.length==1){
					thisString = "0"+thisString;
				}// if:  string is too short
				layerString += thisString;		// append the data
			}// for:  height
		}// for:  width
		compact_obj.layers.push( layerString );
	}// for:  layers
	
	// collision
	// "_" prevents old versions of the XML reader from seeing this as a HUGE number
	compact_obj.collision = "_" + formats[1].create.compressedCollision( expanded_obj.collision, expanded_obj.width, expanded_obj.height );
	/*
	var collisionString = "_";		// prevents XML reader from seeing this as a HUGE number
	for(var xx=0; xx<expanded_obj.width; xx++)
	{
		for(var yy=0; yy<expanded_obj.height; yy++)
		{
			var thisData = expanded_obj.collision[xx][yy];
			var thisString = thisData.toString( 36 );
			collisionString += thisString;		// append the data
		}// for:  height
	}// for:  width
	compact_obj.collision = collisionString;
	*/
	// output the result
	return compact_obj;
}// create compressedMap()

// create collision value  (blank  AKA  value 0)
formats[1].create.blankCollisionValue = function(){
	return 0;
}// create blank collision value()



// create tile data... from selection tile data		(redundant, because they use the same format)
formats[1].copy.tile = function( tileData ){
	return {
		chipset: tileData.chipset,
		x: tileData.x,
		y: tileData.y
	}
}




// shift tiles
formats[1].modify.shiftTilesHorz = function( xOffset ){
	if(xOffset === 0)		return;		// Do nothing
	var numTilesX = Math.abs(xOffset);
	if(numTilesX > data.get.width())		numTilesX = data.get.width();
	
	// shift tiles
	for(var l=0; l<current.data.layers.length; l++)
	{// for:  each layer
		// shift horz
		var thisRow = current.data.layers[l];
		// create new tiles  (as a 2D array)
		var newCols = [];
		for(var cx=0; cx<numTilesX; cx++){
			newCols[cx] = [];
			for(var cy=0; cy<current.data.height; cy++){
				newCols[cx][cy] = formats[1].create.blankTile();
			}// for:  height of a column
		}// for:  horz tiles to add
		// shift left
		if(xOffset < 0){
			// remove tiles from the left
			thisRow.splice(0, numTilesX);
			// add new columns to the right
			thisRow.splice.apply( thisRow, [thisRow.length,0].concat(newCols) );
		}
		// shift right
		if(xOffset > 0){
			// remove tiles from the right
			thisRow.splice(-numTilesX, numTilesX);
			// add new tiles to the left
			thisRow.splice.apply( thisRow, [0,0].concat(newCols) );
		}
	}// for:  each layer
	
	// shift collision
	// shift horz
	var thisRow = current.data.collision;
	// create new tiles  (as a 2D array)
	var newCols = [];
	for(var cx=0; cx<numTilesX; cx++){
		newCols[cx] = [];
		for(var cy=0; cy<current.data.height; cy++){
			newCols[cx][cy] = data.create.blankCollisionValue();
		}// for:  height of a column
	}// for:  horz tiles to add
	// shift left
	if(xOffset < 0){
		// remove tiles from the left
		thisRow.splice(0, numTilesX);
		// add new columns to the right
		thisRow.splice.apply( thisRow, [thisRow.length,0].concat(newCols) );
	}
	// shift right
	if(xOffset > 0){
		// remove tiles from the right
		thisRow.splice(-numTilesX, numTilesX);
		// add new tiles to the left
		thisRow.splice.apply( thisRow, [0,0].concat(newCols) );
	}
}// modify shiftTilesHorz()


formats[1].modify.shiftTilesVert = function( yOffset ){
	if(yOffset === 0)		return;		// Do nothing
	var numTilesY = Math.abs(yOffset);
	if(numTilesY > data.get.height())		numTilesY = data.get.height();
	
	// shift tiles
	for(var l=0; l<current.data.layers.length; l++)
	{// for:  each layer
		// shift vert
		for(var xx=0; xx<current.data.width; xx++)
		{// for:  width
			// create Y new tiles  (as an array)
			var newCol = [];
			for(var t=0; t<numTilesY; t++){
				newCol[t] = formats[1].create.blankTile();
			}
			var thisColumn = current.data.layers[l][xx];
			// shift up
			if(yOffset < 0){
				// remove Y tiles from the top
				thisColumn.splice(0,numTilesY);
				// add new tiles to the bottom
				thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat(newCol) );
			}
			// shift down
			if(yOffset > 0){
				// remove Y tiles from the bottom
				thisColumn.splice(-numTilesY,numTilesY);
				// add new tiles to the top
				thisColumn.splice.apply( thisColumn, [0,0].concat(newCol) );
			}
		}// for:  width
	}// for:  each layer
	
	
	
	// shift collision
	// shift vert
	for(var xx=0; xx<current.data.width; xx++)
	{// for:  width
		// create Y new tiles  (as an array)
		var newCol = [];
		for(var t=0; t<numTilesY; t++){
			newCol[t] = data.create.blankCollisionValue();
		}
		var thisColumn = current.data.collision[xx];
		// shift up
		if(yOffset < 0){
			// remove Y tiles from the top
			thisColumn.splice(0,numTilesY);
			// add new tiles to the bottom
			thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat(newCol) );
		}
		// shift down
		if(yOffset > 0){
			// remove Y tiles from the bottom
			thisColumn.splice(-numTilesY,numTilesY);
			// add new tiles to the top
			thisColumn.splice.apply( thisColumn, [0,0].concat(newCol) );
		}
	}// for:  width
}// modify shiftTilesVert()




	
// wrap tiles  (horizontally)
formats[1].modify.wrapTilesHorz = function( xOffset ){
	if(xOffset === 0)		return;		// Do nothing
	var numTilesX = Math.abs(xOffset);
	// limit to map size
	while(xOffset < 0){
		xOffset += data.get.width();
	}
	xOffset %= data.get.width();
	
	// wrap tiles
	for(var l=0; l<current.data.layers.length; l++){
		var thisGrid = current.data.layers[l];
		// wrap right
		if(xOffset > 0){
			// remove columns from the right side
			var removed = thisGrid.splice( -numTilesX, numTilesX );
			// add these columns to the left side
			thisGrid.splice.apply( thisGrid, [0,0].concat(removed) );
		}// if:  wrap right
		/*
		// wrap left
		if(xOffset < 0){
			// remove columns from the left side
			var removed = thisGrid.splice( 0, numTilesX );
			// add these columns to the right side
			thisGrid.splice.apply( thisGrid, [thisGrid.length,0].concat(removed) );
		}// if:  wrap left
		*/
	}// for:  each layer
	
	// wrap collision
	var thisGrid = current.data.collision;
	// wrap right
	if(xOffset > 0){
		// remove columns from the right side
		var removed = thisGrid.splice( -numTilesX, numTilesX );
		// add these columns to the left side
		thisGrid.splice.apply( thisGrid, [0,0].concat(removed) );
	}// if:  wrap right
	/*
	// wrap left
	if(xOffset < 0){
		// remove columns from the left side
		var removed = thisGrid.splice( 0, numTilesX );
		// add these columns to the right side
		thisGrid.splice.apply( thisGrid, [thisGrid.length,0].concat(removed) );
	}// if:  wrap left
	*/
}// modify wrapTilesHorz()


// wrap tiles  (vertically)
formats[1].modify.wrapTilesVert = function( yOffset ){
	if(yOffset === 0)		return;		// Do nothing
	var numTilesY = Math.abs(yOffset);
	// limit to map size
	while(yOffset < 0){
		yOffset += data.get.height();
	}
	yOffset %= data.get.height();
	
	// wrap tiles
	for(var l=0; l<current.data.layers.length; l++){
		var thisGrid = current.data.layers[l];
		// wrap down
		if(yOffset > 0){
			for(var xx=0; xx<current.data.width; xx++){
				var thisColumn = thisGrid[xx];
				// remove tiles from the bottom
				var removed = thisColumn.splice( -numTilesY, numTilesY );
				// add these tiles to the top
				thisColumn.splice.apply( thisColumn, [0,0].concat(removed) );
			}// for:  width
		}// if:  wrap down
		/*
		// wrap up
		if(yOffset < 0){
			for(var xx=0; xx<current.data.width; xx++){
				var thisColumn = thisGrid[xx];
				// remove tiles from the top
				var removed = thisColumn.splice( 0, numTilesY );
				// add these tiles to the bottom
				thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat(removed) );
			}// for:  width
		}// if:  wrap up
		*/
	}// for:  each layer
	
	// wrap collision
	var thisGrid = current.data.collision;
	// wrap down
	if(yOffset > 0){
		for(var xx=0; xx<current.data.width; xx++){
			var thisColumn = thisGrid[xx];
			// remove tiles from the bottom
			var removed = thisColumn.splice( -numTilesY, numTilesY );
			// add these tiles to the top
			thisColumn.splice.apply( thisColumn, [0,0].concat(removed) );
		}// for:  width
	}// if:  wrap down
	/*
	// wrap up
	if(yOffset < 0){
		for(var xx=0; xx<current.data.width; xx++){
			var thisColumn = thisGrid[xx];
			// remove tiles from the top
			var removed = thisColumn.splice( 0, numTilesY );
			// add these tiles to the bottom
			thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat(removed) );
		}// for:  width
	}// if:  wrap up
	*/
}// modify wrapTilesVert()



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// format 2 is format 1
formats[2] = formats[1];
